The first release of 2018! :tada:

We have contributions from 10 people outside of Load Impact in this release, yay! To celebrate that and make onboarding of new users and contributors easier we’ve improved the [README](https://github.com/loadimpact/k6) to give a better overview of the project and the [Contributing guide](https://github.com/loadimpact/k6/blob/master/CONTRIBUTING.md) with better instructions how to get a k6 dev environment set up.

A big thanks to the following people for contributing to this release: @antekresic, @borjacampina, @cstyan, @dstpierre, @ivoreis, @jonathon-l, @marklagendijk, @Ripolin, @tbroadley, and @tmcgannon
 
## New Features!

### HAR to JS converter (#291, #453)
k6 now has a builtin command `k6 convert recording.har > recording.js` to convert HAR files to JS. This is great for being able to quickly go from a browser/proxy recording to a k6 script, a common flow for getting started with a new test case.

Thanks to @borjacampina for their work on this!

**Docs**: [HAR converter](https://docs.k6.io/docs/session-recording-har-support)
 
### CLI/options: RPS limiter
A global request per second limiter has been added to k6. It will trigger if the RPS level goes above the set value, blocking further requests for a short period to maintain the desired level.

```js
export let options = {
    rps: 100
};
```

Or `--rps` on the CLI.

### CLI: Logging in JSON format (#434)
You can now output logs in JSON format! It looks something like this:
`{"level":"debug","msg":"Engine terminated cleanly","time":"2017-12-20T12:30:35Z"}`

Thanks to @ivoreis for this PR!

### k6/http: Automatic decompression of deflate encoded response bodies (#419)
Adds handling of deflate (as specified in [RFC 1950](https://tools.ietf.org/html/rfc1950)) encoded response bodies by automatically decompressing them.
 
### k6/http: Automatic decompression of gzip encoded response bodies (#438)
Same as the one above but for gzip. k6 previously automatically handled gzip compressed bodies as long as no `Accept-Encoding` header was explicitly specified when making a request, but this adds transparent decompression as long as the `Content-Encoding` header in a response is set to gzip.

Thanks to @Ripolin for discovering the discrepancy in the handling of gzipped responses and for fixing it!

### k6/http: TLS handshaking metric (#454)
k6 will now measure TLS handshaking time. The metric is called `http_req_tls_handshaking` and is accessible in scripts as `res.timings.tls_handshaking`.

Thanks to @antekresic for this PR!

### k6/html: Form serialization methods (#435)
This feature adds some missing jQuery APIs for serializing form elements to a URL-encoded string, array or object.

```js
import http from "k6/http";

export default function() {
    let res = http.get(“https://example.com/form”);
    let form = res.html().find('form');
    const serialized = form.serializeObject();
}
```

Thanks to @marklagendijk for their work on this!

**Docs**: [serialize()](https://docs.k6.io/v1.0/docs/selectionserialize), [serializeArray()](https://docs.k6.io/v1.0/docs/selectionserializearray) and [serializeObject()](https://docs.k6.io/v1.0/docs/selectionserializeobject)

### k6/http: Form submission method (#437, #445)
A sister feature to the one above, adding a `submitForm(...)` method to the response object for making it easier to work with HTML form submissions.

```js
import http from "k6/http";

export default function() {
    let res = http.get(“https://example.com/form”);
    res = res.submitForm({ fields: { message: "hello world" });
}
```

Again, thanks to @marklagendijk for their work on this!

**Docs**: [Response.submitForm()](https://docs.k6.io/v1.0/docs/responsesubmitform-params) and [Working with HTML forms](https://docs.k6.io/v1.0/docs/working-with-html-forms)

### k6/http: Add back OPTIONS method (#451)
Up until v0.13.0 k6 supported `CONNECT`, `OPTIONS` and `TRACE` methods, besides the more common HTTP methods. In v0.13.0 these methods were then lost in a big refactor where we switched JS engine from [Otto](github.com/robertkrimen/otto) to [goja](https://github.com/dop251/goja).

Thanks to @cstyan for this PR!

### k6/http: Link click method (#459)
A wrapper around the Selection API to locate an link/anchor tag in the response HTML and generate a click request. It adds a `clickLink(...)` method to the response object.

```js
import http from "k6/http";

export default function() {
    let res = http.get("https://httpbin.org/links/10/0");
    res = res.clickLink({ selector: 'a:nth-child(4)' })
}
```

Yet again, thanks to @marklagendijk for their work on this!

**Docs**: [Response.clickLink()](https://docs.k6.io/v1.0/docs/responseclicklink-params)

### Metrics: `iteration_duration` metric, `vu` and `iter` tags (#460)
A new metric, `iteration_duration`, has been added to k6. It measures the time it takes to run one full iteration of the default/main function. Most builtin metrics (http, group, checks etc.) are now also automatically tagged with `vu` and `iter` tags, representing the VU and iteration number where the metric data point was collected.

### CLI: Specify what stats to report for trend metrics (#462)
A new CLI option `--summary-trend-stats avg,med,max,p(95),p(99),p(99.9)` for specifying what stats to show for trend metrics (response times) in the summary output after a test run has finished.

Thanks @antekresic for this contribution!

### k6/http: Set default user-agent (#466)
By default k6 will now send a user-agent string in the following format: `k6/0.19.0 (https://k6.io/);`.
 
## Bugs fixed!

* k6/http: The val() Selection method now properly returns an empty string for input fields when the value attribute is missing. (#435, thanks @marklagendijk)

* k6/http: Fixed three bugs related to cookie handling when doing redirects. (#479, thanks @marklagendijk)

* Archive: Fixed JSON encoding of <, > and & characters. (#421, thanks @dstpierre)

* Engine: Improved stability of some tests to decrease flakiness of CI builds.

* Stats: Fixed median calculation when sample count is even (#432, thanks @tmcgannon)

* Docs: Fixed typo in README (#433, thanks @tbroadley)

* Docs: Fixed broken link in README (#482, thanks @jonathon-l)